<?php

    namespace Asn\App\Controllers\Search;

    use Asn\Core\Page;
    use Asn\Core\Renderer;
    use Asn\Core\Http\Request;
    use Asn\App\Model\Dimensions;
    use Asn\App\Model\Location;

    class Retail extends Page
    {

        protected $template = 'retail';
        protected $pageName = 'Retail Property Search';
        protected $dimensions;
        protected $location;

        public function __construct(Request $request, Renderer $renderer, Dimensions $dimensions, Location $location)
        {
            parent::__construct($request, $renderer);
            $this->dimensions = $dimensions;
            $this->location = $location;
        }

        /**
         * @throws \Exception
         */
        protected function setTemplateData()
        {
            $this->renderer->addData('page-title', $this->pageName)
                    ->addData('init', 'searchRetailInit')
                    ->addData('dimensions', $this->dimensions->getDimensions())
                    ->addData('areas', $this->location->getAreas());
        }

    }
