<?php

    namespace Asn\App;

    use Asn\Core\Http\Request;
    use Asn\App\Model\Admin\Admin;

    class Bootstrap extends \Asn\Core\Section
    {

        protected $admin;
        protected $user;

        private $appBase;


        public function __construct(Request $request, Admin $admin)
        {
            parent::__construct($request);

            $this->admin = $admin;
            $this->appBase = $this->getAppBase();

            $sectionCamelCased = 'bootstrap' . str_replace(['-', '_', '/'], '', ucwords(strtolower($this->section), '-_'));
            if (is_callable([$this, $sectionCamelCased])) {
                $this->{$sectionCamelCased}();
            }
        }

        private function bootstrap()
        {

        }

    }