<?php

    namespace Asn\App\Model\AgencyPilot;

    use Asn\Core\Database;

    class FetchAuction
    {

        protected $db;
        private $url;

        public function __construct(Database $db)
        {
            $apiUrl = @include __DIR__ . '/../../../config/agencypilot.settings.php';
            $this->db = $db;
            $this->url = $apiUrl['url'].'?w='.$apiUrl['queryParams']['auction'].'&pw='.$apiUrl['password'];
        }

        /**
         * Insert data in local database
         *
         * @return bool
         * @throws \Throwable
         */
        public function insertData(): bool
        {
            try
            {
                $fd = new FetchData();
                $jsonArr = $fd->fetch($this->url);
            }
            catch (\Throwable $thr)
            {
                throw $thr;
            }

            $res = $jsonArr['?????????'];

            if (!isset($res) || count($res) === 0) {
                return false;
            }

            $sqlRows = [];

            for ($i = 0; $i < count($res); $i++) {
                $sqlRows[] = [
                    'name' => $res[$i][''],
                    'date' => $res[$i][''],
                    'no' => $res[$i][''],
                    'venue_address' => $res[$i][''],
                    'longtitude' => $res[$i][''],
                    'latitude' => $res[$i][''],
                    'doors_open_time' => $res[$i][''],
                    'bidding_starts_time' => $res[$i]['']
                ];
            }

            if (count($sqlRows) === 0) {
                throw new \Exception('Array is empty!');
            }

            $this->db->beginTransaction();
            try {
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 0");
                $this->db->exec("DELETE FROM auction");
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 1");

                $sql = /** @lang text */
                        'INSERT INTO auction';
                $this->db->insertMulti($sql, $sqlRows);

                $this->db->commit();
            } catch (\Throwable $thr) {
                $this->db->rollBack();
                throw $thr;
            }

            return true;
        }

    }
