<?php

    namespace Asn\App\Model\AgencyPilot;

    use Asn\Core\Database;

    class FetchProperties
    {
        protected $db;
        private $url;

        public function __construct(Database $db)
        {
            $apiUrl = @include __DIR__ . '/../../../config/agencypilot.settings.php';
            $this->db = $db;
            $this->url = $apiUrl['url'].'?w='.$apiUrl['queryParams']['properties'].'&pw='.$apiUrl['password'];
        }

        /**
         * Insert data in `htc` database
         *
         * @return bool
         * @throws \Throwable
         */
        public function insertData():bool
        {

            $this->insertProperties();
            $this->insertPropertiesData();
            $this->insertAgents();
            $this->insertBrochures();
            $this->insertBulletPoint();
            $this->insertComments();
            $this->insertPhotos();
            $this->insertSolicitor();

            return true;
        }

        /**
         * Insert data in `properties` table
         *
         * @return bool
         * @throws \Throwable
         */
        public function insertProperties():bool
        {
            try
            {
                $fd = new FetchData();
                $jsonArr = $fd->fetch($this->url);
            }
            catch (\Throwable $thr)
            {
                throw $thr;
            }

            $res = $jsonArr['CRITERIA'];

            if (!isset($res) || count($res) === 0) {
                return false;
            }

            $sqlRows = [];

            for ($i = 0; $i < count($res); $i++) {
                if (isset($res[$i]['Key'])) {
                    // Get the district part form the postcode
                    $postcodeDistrict = trim(mb_substr(trim($res[$i]['Postcode']), 0, 4, 'UTF-8'));

                    // Updated comes as "Date(UNIXTIMESTAMP)", get the unix timestamp only
                    $updated = preg_replace("/\D/", '', $res[$i]['Updated']);
                    $lastUnavailableData = preg_replace("/\D/", '', $res[$i]['Last_Unavailable_Date']);
                    $lastAvailableData = preg_replace("/\D/", '', $res[$i]['Last_Available_Date']);
                    $dispalyUntil = preg_replace("/\D/", '', $res[$i]['Display_Until']);

                    if (!is_numeric($updated))
                    {
                        $updated = 0;
                    }
                    if (!is_numeric($lastUnavailableData))
                    {
                        $lastUnavailableData = 0;
                    }
                    if (!is_numeric($lastAvailableData))
                    {
                        $lastAvailableData = 0;
                    }
                    if (!is_numeric($dispalyUntil))
                    {
                        $dispalyUntil = 0;
                    }

                    $sqlRows[] = [
                        '_key' => $res[$i]['Key'],
                        'number' => $res[$i]['Number'],
                        'location_link' => $res[$i]['Location_Link'],
                        'market_status' => $res[$i]['Market_Status'],
                        'description' => $res[$i]['Description'],
                        'uprn' => $res[$i]['UPRN'],
                        'town ' => $res[$i]['Town'],
                        'post_code' => $res[$i]['Postcode'],
                        'post_code_district' => $postcodeDistrict,
                        'unit_name' => $res[$i]['Unit_Name'],
                        'updated' => $updated,
                        'last_unavailable_date' => $lastUnavailableData,
                        'last_available_date' => $lastAvailableData,
                        'display_until' => $dispalyUntil,
                        'latitude' => $res[$i]['Latitude'],
                        'longitude' => $res[$i]['Longitude'],
                        'district' => $res[$i]['District'],
                        'brochure_header' => $res[$i]['BrochureHeader'],
                        'residential' => $res[$i]['Residential'],
                        'receptions' => $res[$i]['Receptions'],
                        'bathrooms' => $res[$i]['Bathrooms'],
                        'freehold' => $res[$i]['Freehold'],
                        'leasehold' => $res[$i]['Leasehold'],
                        'leasehold_term' => $res[$i]['Leasehold_Term'],
                        'size_dimensions' => $res[$i]['Size_Dimension'],
                        'min_size' => $res[$i]['Min_Size'],
                        'max_size' => $res[$i]['Max_Size']
                    ];
                }

                if (count($sqlRows) === 0) {
                    continue;
                }
            }

            $this->db->beginTransaction();
            try {
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 0");
                $this->db->exec("DELETE FROM properties");
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 1");

                $sql = /** @lang text */
                        'INSERT INTO properties ';
                $this->db->insertMulti($sql, $sqlRows);

                $this->db->commit();
            } catch (\Throwable $thr) {
                $this->db->rollBack();
                throw $thr;
            }

            return true;
        }

        /**
         * Insert data in `properties_data` table
         * @return bool
         * @throws \Throwable
         */
        public function insertPropertiesData(): bool
        {
            try {
                $fd = new FetchData();
                $jsonArr = $fd->fetch($this->url);
            } catch (\Throwable $thr) {
                throw $thr;
            }

            $res = $jsonArr['CRITERIA'];

            if (!isset($res) || count($res) === 0) {
                return false;
            }

            $sqlRows = [];

            for ($i = 0; $i < count($res); $i++) {
                if (isset($res[$i]['Key'])) {

                    $sqlRows[] = [
                        '_key' => $res[$i]['Key'],
                        'uprn' => $res[$i]['UPRN'],
                        'building_name' => $res[$i]['Building_Name'],
                        'secondary_name' => $res[$i]['Secondary_Name'],
                        'street' => $res[$i]['Street'],
                        'county' => $res[$i]['County'],
                        'full_address' => $res[$i]['Full_Address'],
                        'display_address' => $res[$i]['Display_Address'],
                        'eaves_height' => $res[$i]['Eaves_Height'],
                        'eaves_dimension' => $res[$i]['Eaves_Dimension'],
                        'area' => $res[$i]['Area'],
                        'dim_name' => $res[$i]['Dim_Name'],
                        'status_name' => $res[$i]['Status_Name'],
                        'tenure' => $res[$i]['Tenure'],
                        'date_reg' => $res[$i]['DateReg'],
                        'serv_chg' => $res[$i]['Serv_Chg'],
                        'northling' => $res[$i]['Northing'],
                        'eastling' => $res[$i]['Easting'],
                        'account_manager_id' => $res[$i]['AccountManagerID'],
                        'partner_office_id' => $res[$i]['PartnerOfficeID'],
                        'tennure_comments' => $res[$i]['Tenure_Comments'],
                        'ud_droplist_1' => $res[$i]['UDdroplist1'],
                        'ud_droplist_2' => $res[$i]['UDdroplist2'],
                        'virtual_tour_url' => $res[$i]['VirtualTourURL'],
                        'owner_logo' => $res[$i]['Owner_Logo'],
                        'ind_estates_id' => $res[$i]['IndEstatesID'],
                        'html_1' => $res[$i]['HTML1'],
                        'html_2' => $res[$i]['HTML2'],
                        'html_3' => $res[$i]['HTML3'],
                        'html_4' => $res[$i]['HTML4'],
                        'currency_link' => $res[$i]['Currency_Link'],
                        'p_order' => $res[$i]['POrder'],
                        'tool_1_link' => $res[$i]['Tool1_Link'],
                        'negot_2' => $res[$i]['Negot_2'],
                        'sol_cont_link' => $res[$i]['Sol_Cont_Link'],
                        'owner_link' => $res[$i]['Owner_Link'],
                        'dis_id' => $res[$i]['Dis_ID'],
                        'ls_no' => $res[$i]['LS_No'],
                        'itza_id' => $res[$i]['ITZA_ID'],
                        'checkbox' => $res[$i]['Checkbox'],
                        'checkbox2' => $res[$i]['Checkbox2']
                    ];
                }

                if (count($sqlRows) === 0) {
                    continue;
                }
            }

            $this->db->beginTransaction();
            try {
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 0");
                $this->db->exec("DELETE FROM properties_data");
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 1");

                $sql = /** @lang text */
                        'INSERT INTO properties_data ';
                $this->db->insertMulti($sql, $sqlRows);

                $this->db->commit();
            } catch (\Throwable $thr) {
                $this->db->rollBack();
                throw $thr;
            }

            return true;
        }

        /**
         * Insert agents
         *
         * @return bool
         * @throws \Throwable
         */
        public function insertAgents(): bool
        {
            try {
                $fd = new FetchData();
                $jsonArr = $fd->fetch($this->url);
            } catch (\Throwable $thr) {
                throw $thr;
            }
            $res = $jsonArr['CRITERIA'];

            if (!isset($res) || count($res) === 0) {
                return false;
            }

            $sqlRows = [];

            for ($i = 0; $i < count($res); $i++) {
                if (isset($res[$i]['Agent_Name'])) {

                    $id = sha1($res[$i]['Key'] . trim($res[$i]['Agent_Name']).trim($res[$i]['Agent_Contact']), true);
                    $sqlRows[] = ['id' => $id, '_key' => $res[$i]['Key'], 'uprn' => $res[$i]['UPRN'], 'main' => 1, 'agent_name' => $res[$i]['Agent_Contact'], 'agent_contact' => $res[$i]['Agent_Contact'], 'agent_tel' => $res[$i]['Agent_Tel'], 'agent_email' => $res[$i]['Agent_Email'], 'agent_logo' => $res[$i]['Agent_Logo']];
                }

                if (isset($res[$i]['Agent_2_Name'])) {

                    $id = sha1($res[$i]['Key'] . trim($res[$i]['Agent_2_Name']).trim($res[$i]['Agent_2_Contact']), true);
                    $sqlRows[] = ['id' => $id, '_key' => $res[$i]['Key'], 'uprn' => $res[$i]['UPRN'], 'main' => 0, 'agent_name' => $res[$i]['Agent_2_Name'], 'agent_contact' => $res[$i]['Agent_2_Contact'], 'agent_tel' => $res[$i]['Agent_2_Tel'], 'agent_email' => $res[$i]['Agent_2_Email'], 'agent_logo' => $res[$i]['Agent_2_Logo']];
                }

                if (isset($res[$i]['Agent_3_Name'])) {

                    $id = sha1($res[$i]['Key'] . trim($res[$i]['Agent_3_Name']).trim($res[$i]['Agent_3_Contact']), true);
                    $sqlRows[] = ['id' => $id, '_key' => $res[$i]['Key'], 'uprn' => $res[$i]['UPRN'], 'main' => 0, 'agent_name' => $res[$i]['Agent_3_Name'], 'agent_contact' => $res[$i]['Agent_3_Contact'], 'agent_tel' => $res[$i]['Agent_3_Tel'], 'agent_email' => $res[$i]['Agent_3_Email'], 'agent_logo' => $res[$i]['Agent_3_Logo']];
                }

                if (count($sqlRows) === 0) {
                    continue;
                }
            }

            $this->db->beginTransaction();
            try {
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 0");
                $this->db->exec("DELETE FROM agents");
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 1");

                $sql = /** @lang text */
                        'INSERT IGNORE INTO agents';
                $this->db->insertMulti($sql, $sqlRows);

                $this->db->commit();
            } catch (\Throwable $thr) {
                $this->db->rollBack();
                throw $thr;
            }

            return true;
        }

        /**
         * Insert brochures
         *
         * @return bool
         * @throws \Throwable
         */
        public function insertBrochures(): bool
        {

            try {
                $fd = new FetchData();
                $jsonArr = $fd->fetch($this->url);
            } catch (\Throwable $thr) {
                throw $thr;
            }
            $res = $jsonArr['CRITERIA'];

            if (!isset($res) || count($res) === 0) {
                return false;
            }

            $sqlRows = [];

            for ($i = 0; $i < count($res); $i++) {
                for ($k = 1; $k <= 10; $k++) {
                    $b = 'BrochureURL' . $k;

                    if (isset($res[$i][$b])) {
                        $id = sha1($res[$i]['Key'] . rand(), true);
                        $sqlRows[] = ['brochure_id' => $id, '_key' => $res[$i]['Key'], 'uprn' => $res[$i]['UPRN'], 'brochure_url ' => $res[$i][$b]];
                    }
                }

                if (count($sqlRows) === 0) {
                    continue;
                }
            }

            $this->db->beginTransaction();
            try {
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 0");
                $this->db->exec("DELETE FROM brochures");
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 1");

                $sql = /** @lang text */
                        'INSERT INTO brochures';
                $this->db->insertMulti($sql, $sqlRows);

                $this->db->commit();
            } catch (\Throwable $thr) {
                $this->db->rollBack();
                throw $thr;
            }

            return true;
        }

        /**
         * Insert comments
         *
         * @return bool
         * @throws \Throwable
         */
        public function insertComments(): bool
        {
            try {
                $fd = new FetchData();
                $jsonArr = $fd->fetch($this->url);
            } catch (\Throwable $thr) {
                throw $thr;
            }
            $res = $jsonArr['CRITERIA'];

            if (!isset($res) || count($res) === 0) {
                return false;
            }

            $sqlRows = [];

            for ($i = 0; $i < count($res); $i++) {
                for ($k = 1; $k <= 10; $k++) {
                    $s = 'Comments' . $k;

                    if (isset($res[$i][$s])) {
                        $id = sha1($res[$i]['Key'] . rand(), true);
                        $sqlRows[] = ['comment_id' => $id, '_key' => $res[$i]['Key'], 'uprn' => $res[$i]['UPRN'], 'comment' => $res[$i][$s]];
                    }
                }

                if (count($sqlRows) === 0) {
                    continue;
                }
            }

            $this->db->beginTransaction();
            try {
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 0");
                $this->db->exec("DELETE FROM comments");
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 1");

                $sql = /** @lang text */
                        'INSERT INTO comments ';
                $this->db->insertMulti($sql, $sqlRows);

                $this->db->commit();
            } catch (\Throwable $thr) {
                $this->db->rollBack();
                throw $thr;
            }

            return true;
        }

        /**
         * Insert Bullet Points
         *
         * @return bool
         * @throws \Throwable
         */
        public function insertBulletPoint(): bool
        {
            try {
                $fd = new FetchData();
                $jsonArr = $fd->fetch($this->url);
            } catch (\Throwable $thr) {
                throw $thr;
            }

            $res = $jsonArr['CRITERIA'];

            if (!isset($res) || count($res) === 0) {
                return false;
            }

            $sqlRows = [];

            for ($i = 0; $i < count($res); $i++) {
                for ($k = 1; $k <= 10; $k++) {
                    $s = 'BulletPoint' . $k;

                    if (isset($res[$i][$s])) {
                        $id = sha1($res[$i]['Key'] . rand(), true);
                        $sqlRows[] = ['bullet_point_id' => $id, '_key' => $res[$i]['Key'], 'uprn' => $res[$i]['UPRN'], 'bullet_point' => $res[$i][$s]];
                    }
                }

                if (count($sqlRows) === 0) {
                    continue;
                }
            }

            $this->db->beginTransaction();
            try {
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 0");
                $this->db->exec("DELETE FROM bullet_point");
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 1");

                $sql = /** @lang text */
                        'INSERT INTO bullet_point ';
                $this->db->insertMulti($sql, $sqlRows);

                $this->db->commit();
            } catch (\Throwable $thr) {
                $this->db->rollBack();
                throw $thr;
            }

            return true;
        }

        /**
         * Insert Photos
         *
         * @return bool
         * @throws \Throwable
         */
        public function insertPhotos(): bool
        {
            try {
                $fd = new FetchData();
                $jsonArr = $fd->fetch($this->url);
            } catch (\Throwable $thr) {
                throw $thr;
            }
            $res = $jsonArr['CRITERIA'];

            if (!isset($res) || count($res) === 0) {
                return false;
            }

            $sqlRows = [];

            for ($i = 0; $i < count($res); $i++) {
                if (isset($res[$i]['PhotoKey'])) {
                    $sqlRows[] = [
                        'photo_key' => $res[$i]['PhotoKey'],
                        '_key' => $res[$i]['Key'],
                        'uprn' => $res[$i]['UPRN'],
                        'photo_map_key' => $res[$i]['PhotoMapKey'],
                        'photo_floor_plan_key' => $res[$i]['PhotoFloorPlanKey'],
                        'photo_floor_plan_url' => $res[$i]['PhotoFloorPlanURL'],
                        'photo_epc_key' => $res[$i]['PhotoEpcKey'],
                        'photo_qr_key' => $res[$i]['PhotoQRKey'],
                        'all_photo_keys' => $res[$i]['AllPhotoKeys'],
                        'all_photo_names' => $res[$i]['AllPhotoNames'],
                    ];
                }

                if (count($sqlRows) === 0) {
                    continue;
                }
            }

            $this->db->beginTransaction();
            try {
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 0");
                $this->db->exec("DELETE FROM photos ");
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 1");

                $sql = /** @lang text */
                        'INSERT INTO photos ';
                $this->db->insertMulti($sql, $sqlRows);

                $this->db->commit();
            } catch (\Throwable $thr) {
                $this->db->rollBack();
                throw $thr;
            }

            return true;
        }

        /**
         * Insert Solicitor
         *
         * @return bool
         * @throws \Throwable
         */
        public function insertSolicitor(): bool
        {
            try {
                $fd = new FetchData();
                $jsonArr = $fd->fetch($this->url);
            } catch (\Throwable $thr) {
                throw $thr;
            }

            $res = $jsonArr['CRITERIA'];

            if (!isset($res) || count($res) === 0) {
                return false;
            }

            $sqlRows = [];

            for ($i = 0; $i < count($res); $i++) {
                if (isset($res[$i]['Solicitor_Name'])) {
                    $id = sha1($res[$i]['Key'] . rand(), true);

                    $sqlRows[] = [
                        'solicitor_id ' => $id,
                        '_key' => $res[$i]['Key'],
                        'uprn' => $res[$i]['UPRN'],
                        'solicitor_name' => $res[$i]['Solicitor_Name'],
                        'solicitor_telephone' => $res[$i]['Solicitor_Telephone'],
                        'solicitor_logo' => $res[$i]['Solicitor_Logo']
                    ];
                }
            }

            if (count($sqlRows) === 0) {
                throw new \Exception('Array is empty!');
            }

            $this->db->beginTransaction();
            try {
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 0");
                $this->db->exec("DELETE FROM properties_solicitor");
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 1");

                $sql = /** @lang text */
                        'INSERT IGNORE INTO properties_solicitor ';
                $this->db->insertMulti($sql, $sqlRows);

                $this->db->commit();
            } catch (\Throwable $thr) {
                $this->db->rollBack();
                throw $thr;
            }

            return true;
        }

        /**
         *
         * @param string $paramName
         * @param string $paramValue
         *
         * @return FetchProperties
         */
        public function setUrlParams(string $paramName, string $paramValue):FetchProperties
        {
            if($paramName)
            {
                $paramName = urlencode($paramName);
                $paramValue = urlencode($paramValue);
                $this->url = $this->url."&$paramName=$paramValue";
            }

            return $this;
        }

    }
