<?php

    namespace Asn\Core;

    class Encryption
    {

        const METHOD = 'aes-256-cbc';

        private $encKey;
        private $hmacKey;

        public function __construct()
        {
            $settings = @include __DIR__ . '/../config/security.config.php';
            if (!is_array($settings)) {
                exit();
            }

            $this->encKey = base64_decode($settings['encKey']);
            $this->hmacKey = base64_decode($settings['hmacKey']);
        }

        /**
         *
         * @param string $message
         * @return string
         * @throws \Exception
         */
        public function encrypt(string $message): string
        {
            if (mb_strlen($this->encKey, '8bit') !== 32) {
                throw new \Exception("Invalid key");
            }
            $ivsize = openssl_cipher_iv_length(self::METHOD);
            $iv = openssl_random_pseudo_bytes($ivsize);

            $ciphertext = openssl_encrypt($message, self::METHOD, $this->encKey, OPENSSL_RAW_DATA, $iv);
            return $iv . $ciphertext . hash_hmac('SHA256', $iv . $ciphertext, $this->hmacKey);
        }

        /**
         *
         * @param string $messageBundle
         * @return boolean
         * @throws Exception
         */
        public function decrypt(string $messageBundle)
        {

            if (mb_strlen($this->encKey, '8bit') !== 32) {
                throw new Exception("Invalid key");
            }

            $len = mb_strlen($messageBundle, '8bit');
            $message = mb_substr($messageBundle, 0, $len - 64, '8bit');
            $hmacBundle = mb_substr($messageBundle, $len - 64, null, '8bit');

            if (!hash_equals(hash_hmac('SHA256', $message, $this->hmacKey), $hmacBundle)) {
                return false;
            }

            $ivsize = openssl_cipher_iv_length(self::METHOD);
            $iv = mb_substr($message, 0, $ivsize, '8bit');
            $ciphertext = mb_substr($message, $ivsize, null, '8bit');

            return openssl_decrypt($ciphertext, self::METHOD, $this->encKey, OPENSSL_RAW_DATA, $iv);
        }

    }