<?php

    namespace Asn\Core;

    use Asn\Core\Http\Request;
    use Asn\Core\Renderer;

    abstract class Page
    {

        protected $request;
        protected $renderer;

        /**
         *
         * @param Request $request
         * @param Renderer $renderer
         */
        protected function __construct(Request $request, Renderer $renderer)
        {
            $this->request = $request;
            $this->renderer = $renderer;
        }

        /**
         * Sets the data to be used in the template
         */
        abstract protected function setTemplateData();

        /**
         * Renders and sends the page to the client
         */
        public function show()
        {
            $this->setTemplateData();
            
            $this->renderer->addData('js', $this->renderer->renderJs(), 'raw')
                    ->addData('css', $this->renderer->renderCss(), 'raw')
                    ->render($this->template);
        }

    }