import {ajax} from './ajax-promise';

/**
 *
 * @param {type} propertyType
 * @param {type} filterId - the form id
 * @param {type} page - page number
 * @param {type} perPage - records per page
 * @returns {Promise}
 */
export function propertyFinder(propertyType, filterId, page, perPage) {

    const doc = document;
    let   form = doc.getElementById(filterId),
        searchResContainer = doc.getElementById('search-results'),
        oFD = form ? new FormData(form) : new FormData();

    oFD.append("propertyType", propertyType);
    oFD.append("filterId", filterId);
    oFD.append("page", page);
    oFD.append("perPage", perPage);

    return ajax({
        "URL": "/ajax/find-properties.php",
        "reqParams": oFD
    }).then((resp) => {

        if (resp.success === true) {

            searchResContainer.innerHTML = resp.result;
        } else {
            searchResContainer.textContent = '';
        }

        const msgE = doc.getElementById('msg');
        if (msgE && resp.msg) {
            msgE.textContent = resp.msg;
        }
    });
}

